<?php
// Iestata kļūdu paziņojumu rādīšanu
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Pārbauda, vai ir POST pieprasījums
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // Iegūst datus no ievadlaukiem
    $title = $_POST['title'];
    $author = $_POST['author'];
    $year = $_POST['year'];
    $desc = $_POST['description'];

    $mysqli = require __DIR__ . "/../db/database.php";

    // Pārbauda, vai ir norādītais ID un tas nav tukšs
    if(isset($_POST['id']) && $_POST['id']!= ""){
        // Ja ir norāditais id, tad to definē kā id
        $id = $_POST['id'];

        // Pārbauda, vai ir augšupielādēts fails
        if(isset($_FILES['image']) && $_FILES['image']['size'] > 0) {
            // Ja ir, iegūst faila datus
            $fileData = file_get_contents($_FILES['image']['tmp_name']);
            $uploadDir = __DIR__ . '/../uploads/'; 
            $newFileName = uniqid() . '_' . $_FILES['image']['name']; 
            $uploadPath = $uploadDir . $newFileName;
    
            // Pārvieto failu uz norādīto atrašanās vietu
            if(move_uploaded_file($_FILES['image']['tmp_name'], $uploadPath)) {
    
                // Atjaunina grāmatas bildi datubāzē
                $sql_get_image = "SELECT image FROM books WHERE id = $id";

                $result = $mysqli->prepare($sql_get_image);
                $result->execute();
                $image = $result->get_result()->fetch_assoc()['image'];
                unlink($uploadDir. $image);

                // Atjaunina grāmatas datus datubāzē
                $sql_insert_book = "UPDATE books
                SET title = ?, description = ?, author = ?, year = ?, image = ? WHERE id = $id";
                $stmt_insert_book = $mysqli->prepare($sql_insert_book);
                $stmt_insert_book->bind_param("sssis", $title, $desc, $author, $year,  $newFileName);

                // Pārbauda, vai pieprasījums tika veiksmīgi izpildīts
                if($stmt_insert_book->execute()) {
                    // Ja tika veiksmīgi izpildīts, izvada ziņojumu un atjauno lapu
                    $message = "Grāmata veiksmīgi atjaunināta!";
                    header("Location: http://lasitava.000webhostapp.com/admin/controlpanel.php");
                } else {
                    // Ja netika veiksmīgi izpildīts, izvada kļūdas ziņojumu
                    $error_message = "Kļūda atjaunojot grāmatu: " . $mysqli->error;
                }
            } else {
                // Ja neizdevās pārvietot failu, izvada kļūdas ziņojumu
                $error_message = "Kļūda pārvietojot augšupielādēto failu.";
            }
        } else {
            // Ja nav augšupielādēts fails, atjauno grāmatas datus datubāzē
            $sql_insert_book = "UPDATE books
            SET title = ?, description = ?, author = ?, year = ? WHERE id = $id";
            $stmt_insert_book = $mysqli->prepare($sql_insert_book);
            $stmt_insert_book->bind_param("sssi", $title, $desc, $author, $year);

            // Pārbauda, vai pieprasījums tika veiksmīgi izpildīts
            if($stmt_insert_book->execute()) {
                // Ja tika veiksmīgi izpildīts, izvada ziņojumu un atjauno lapu
                $message = "Grāmata veiksmīgi atjaunināta!";
                header("Location: http://lasitava.000webhostapp.com/admin/controlpanel.php");
            } else {
                // Ja netika veiksmīgi izpildīts, izvada kļūdas ziņojumu
                $error_message = "Kļūda atjaunojot grāmatu: " . $mysqli->error;
            }
        }
    
        
    } else {
        // Ja nav norādītais ID vai tas ir tukšs, pievieno jaunu grāmatu
        if(isset($_FILES['image'])) {

            // Iegūst faila datus
            $fileData = file_get_contents($_FILES['image']['tmp_name']);
            $uploadDir = __DIR__ . '/../uploads/'; 
            $newFileName = uniqid() . '_' . $_FILES['image']['name']; 
            $uploadPath = $uploadDir . $newFileName;
    
            // Pārvieto failu uz norādīto atrašanās vietu
            if(move_uploaded_file($_FILES['image']['tmp_name'], $uploadPath)) {
    
                // Ievieto jaunu grāmatu datubāzē
                $sql_insert_book = "INSERT INTO books(title, author, year, description, image) VALUES (?, ?, ?, ?, ?)";
                $stmt_insert_book = $mysqli->prepare($sql_insert_book);
                $stmt_insert_book->bind_param("ssiss", $title, $author, $year, $desc, $newFileName);
    
                // Pārbauda, vai pieprasījums tika veiksmīgi izpildīts
                if($stmt_insert_book->execute()) {
                    // Ja tas tika veiksmīgi izpildīts, izvada ziņojumu un atjauno lapu
                    $message = "Grāmata veiksmīgi pievienota!";
                    header("Location: http://lasitava.000webhostapp.com/admin/controlpanel.php");
                } else {
                    // Ja tas netika veiksmīgi izpildīts, izvada kļūdu
                    $error_message = "Kļūda ievietojot grāmatu: " . $mysqli->error;
                }

            } else {
                // Ja failu neizdevās pārvietot, izvada kļūdu
                $error_message = "Kļūda pārvietojot augšupielādēto failu.";
            }

        } else {
            // Ja neizdevās augšupielādēt failu, izvada kļūdu
            $error_message = "Kļūda augšupielādējot failu: " . $_FILES['image']['error'];
        }
    }
} 


